/* os dependent functions */
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include "byteorder.h"
#include "lowlevel.h"
#include "global.h"
#include "sndconfig.h"

int init_soundcard(double rate, int bits)
{
#ifdef	ECHO_TO_SOUNDCARD
  if (global.echo) {
    if ((global.soundcard_fd = open(SOUND_DEV, O_WRONLY
#ifdef NONBLOCKING_AUDIO
                                                        | O_NONBLOCK
#endif
                                                       , 0)) == EOF) {
	perror("");
        fprintf(stderr, "Cannot open "SOUND_DEV"\n");
        global.echo = 0;
    } else { 
#if defined(sun) || defined(__sun) || defined(__sun__)
#include <sys/audioio.h>
        audio_info_t            info;

        AUDIO_INITINFO(&info);
        info.play.sample_rate = rate;
        info.play.channels = global.channels;
        info.play.precision = bits;
        info.play.encoding = AUDIO_ENCODING_LINEAR;
        info.play.pause = 0;
        info.record.pause = 0;
        info.monitor_gain = 0;
        if (ioctl(global.soundcard_fd, AUDIO_SETINFO, &info) < 0) {
	    fprintf(stderr, "Cannot init "SOUND_DEV" (sun)\n");
	    global.echo = 0;
	}
#endif
#if defined(UNIX_SOUND_SYSTEM)
	int dummy;
	int garbled_rate = rate;
	int stereo = (global.channels == 2);
	int format = bits == 8 ? AFMT_U8 :
        	(MY_LITTLE_ENDIAN ? AFMT_S16_LE : AFMT_S16_BE);
	int mask;

	if (ioctl(global.soundcard_fd, (int)SNDCTL_DSP_GETBLKSIZE, &dummy) == -1) {
	    fprintf(stderr, "Cannot get blocksize for "SOUND_DEV"\n");
	    global.echo = 0;
	}
	if (ioctl(global.soundcard_fd, (int)SNDCTL_DSP_SYNC, NULL) == -1) {
	    fprintf(stderr, "Cannot sync for "SOUND_DEV"\n");
	    global.echo = 0;
	}

	/* check, if the sound device can do the requested format */
	if (ioctl(global.soundcard_fd, (int)SNDCTL_DSP_GETFMTS, &mask) == -1) {
		perror("fatal error:");
		return -1;
	}
	if ((mask & format) == 0) {
		fprintf(stderr, "sound format (%d bits signed) is not available\n", bits);
		if ((mask & AFMT_U8) != 0) {
			bits = 8;
			format = AFMT_U8;
		}
	}
	if (ioctl(global.soundcard_fd, (int)SNDCTL_DSP_SETFMT, &format) == -1) {
	    fprintf(stderr, "Cannot set %d bits/sample for "SOUND_DEV"\n",bits);
	    global.echo = 0;
	}

	/* limited sound devices may not support stereo */
	if (stereo
	    && ioctl(global.soundcard_fd, (int)SNDCTL_DSP_STEREO, &stereo) == -1) {
	    fprintf(stderr, "Cannot set stereo mode for "SOUND_DEV"\n");
	    stereo = 0;
	}
	if (!stereo
            && ioctl(global.soundcard_fd, (int)SNDCTL_DSP_STEREO, &stereo) == -1) {
	    fprintf(stderr, "Cannot set mono mode for "SOUND_DEV"\n");
	    global.echo = 0;
	}

	/* set the sample rate */
	if (ioctl(global.soundcard_fd, (int)SNDCTL_DSP_SPEED, &garbled_rate) == -1) {
	    fprintf(stderr, "Cannot set rate %g Hz for "SOUND_DEV"\n",rate);
	    global.echo = 0;
	}
	if ( abs((long)rate - garbled_rate) > rate / 20) {
	    fprintf(stderr, "sound device: next best sample rate is %d\n",garbled_rate);
	}
#endif
    }
  }
#if 0 
  /* if echo is enabled, set speed to 1x */
  if (global.echo)
    global.speed = 1;
#endif
#endif
  return 0;
}
